/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__request.h"
#include "mx__partner.h"
#include "mx__debug_dump.h"
#include "mx__error.h"
#include "mx_debug.h"
#include "mx_util.h"
#include "mx__ack.h"

void
mx__queue_liback(mx_endpoint_t ep, struct mx__partner *partner, int force)
{
  mx_assert(force || partner->ack_list.tqe_prev == 0);
  mx_assert(force || MX__SEQNO(partner->fully_recv_seq) != partner->recv_acked);
  if (!partner->liback_pending) {
    union mx_request * a = mx__rl_alloc(ep);
    mx_fixme_assert(a);
    a->basic.type = MX__REQUEST_TYPE_LIBACK;
    a->basic.partner = partner;
    a->basic.mcp_handle = -1;
    a->liback.eid = partner->eid;
    a->liback.peer_n = partner->peer_index_n;
    a->liback.basic.state = MX__REQUEST_STATE_SEND_QUEUED;
    mx__enqueue_request(&ep->resend_reqq, a);
    ep->liback_count += 1;
    partner->liback_pending = a;
    if (partner->ack_list.tqe_prev) {
      TAILQ_REMOVE(&ep->partners_to_ack, partner, ack_list);
      partner->ack_list.tqe_prev = 0;
    }
  }
}

void
mx__process_resend_list(mx_endpoint_t ep)
{
  struct mx__request_queue_head * list;
  mx_jiffies_t now;
  now = mx_jiffies(ep);
  list = &ep->resend_list;

  while (!mx__isempty_request_queue(list)) {
    union mx_request *r = mx__first_request(list);

#if 0
    mx_assert(now - r->basic.last_send_time >= 0
	      && now - r->basic.last_send_time < 1000 * ep->resend_delay
	      && now && r->basic.last_send_time);
#endif
    if (now - r->basic.last_send_time < ep->resend_delay)
      break;

    mx_assert(!(r->basic.state &  
		(MX__REQUEST_STATE_SEND_QUEUED | 
		 MX__REQUEST_STATE_MCP |
		 MX__REQUEST_STATE_ACKED)));

    if (r->basic.requeued <= 1)
      r->basic.first_send_time = r->basic.last_send_time;
    if (r->basic.requeued >= mx__opt.max_retries ||
	now - r->basic.first_send_time > r->basic.timeout) {
      struct mx__partner * partner = r->basic.partner;

      mx_printf("Max retransmit retries reached (%d) for message\n",
		r->basic.requeued);
      mx__dump_request(ep, r);
      mx_printf("Was trying to contact\n\t");
      mx__print_partner(partner);
      mx_printf("/%d\n", partner->eid);

      /* Disconnect the peer (and drop the requests)
       * See the bottom of mx__partner.c for documentation about disconnection and so */
      mx__partner_cleanup(ep, partner, 1);
      continue;
    }

    mx__spliceout_request(&ep->resend_list, r);

    if (r->basic.type != MX__REQUEST_TYPE_CONNECT &&
	r->basic.type != MX__REQUEST_TYPE_CONNECT_REPLY &&
	r->basic.partner->send_acked != MX__SEQNO(r->basic.send_seq) &&
	((int64_t)r->basic.partner->last_ack - (int64_t)r->basic.last_send_time) < 0) {
      /* put back at end of send list */
      mx__enqueue_request(&ep->resend_list, r);
      r->basic.last_send_time = now;
      MX__EP_STATS_INC(ep, resent_slow);
      continue;
    }
    r->basic.requeued += 1;
    r->basic.state |= MX__REQUEST_STATE_SEND_QUEUED;
#if 0
    if (r->basic.requeued >= 80) {
      r->basic.partner->requeued = MX_MAX(r->basic.partner->requeued, r->basic.requeued);
      mx__queue_liback(ep, r->basic.partner, 1);
    }
#endif

    if (mx__opt.verbose) {
      static int count;
      if (mx__opt.verbose >= 2 || (mx__opt.verbose && count++ < 10)) {
	mx_printf("Send request was not acked, resending, msg_seqnum=0x%x, attempt=%d\n",
		  r->basic.send_seq, r->basic.requeued);
	mx__dump_request(ep, r);
      }
    }

    MX__EP_STATS_INC(ep, resent);
    mx__enqueue_request(&ep->resend_reqq, r);
  }
}

void
mx__process_partners_to_ack(mx_endpoint_t ep)
{
  struct mx__request_queue_head * list;
  struct mx__partner *partner;
  mx_jiffies_t now;
  now = mx_jiffies(ep);
  list = &ep->resend_list;

  partner = TAILQ_FIRST(&ep->partners_to_ack);
  while (partner) {
    struct mx__partner *next = TAILQ_NEXT(partner, ack_list);
    if (now - partner->oldest_recv_time < ep->ack_delay)
      break;
    MX__EP_STATS_INC(ep, delayed_acks);
    mx_assert(!partner->liback_pending);
    TAILQ_REMOVE(&ep->partners_to_ack, partner, ack_list);
    partner->ack_list.tqe_prev = 0;
    mx_assert(MX__SEQNO(partner->fully_recv_seq) != partner->recv_acked);
    mx__queue_liback(ep, partner, 0);
    partner = next;
  }
}
